﻿using System;
using System.Collections.Generic;

namespace HF_Demo
{
    [Serializable]
    public class Script
    {
        private string _descr = "No desc.";
        private string _name = "Unknown Script";
        private List<SingleTask> _taskList = new List<SingleTask>();

        #region Browsables

        public string Name
        {
            get { return _name; }
            set { _name = value; }
        }

        public string ScriptDescription
        {
            get { return _descr; }
            set { _descr = value; }
        }

        public List<SingleTask> Tasks
        {
            get { return _taskList; }
            set { _taskList = value; }
        }

        #endregion

        #region Nested type: SingleTask

        public class SingleTask
        {
            private string _cmd = "";
            private string _data = "";
            private string _descr = "No desc.";
            private string _name = "Unknown Task";
            private string _returnValue = "";
            private bool _returnValueHexFormat = true;

            #region Browsables

            public string Name
            {
                get { return _name; }
                set { _name = value; }
            }

            public string TaskDescription
            {
                get { return _descr; }
                set { _descr = value; }
            }

            public string Command
            {
                get { return _cmd; }
                set { _cmd = value; }
            }

            public string Data
            {
                get { return _data; }
                set { _data = value; }
            }

            public bool ReturnValueCheck {  get; set; }

            public bool ReturnValueHexFormat {
                get { return _returnValueHexFormat; }
                set { _returnValueHexFormat = value; }
            }

            public string ReturnValue
            {
                get { return _returnValue; }
                set { _returnValue = value; }
            }

            public bool LengthCheck { get; set; }

            public bool UsePreviousValue { get; set; }

            public int StripLead { get; set; }

            public int StripTrail { get; set; }

            #endregion
        }

        #endregion
    }
}